"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var TLNoteShape_exports = {};
__export(TLNoteShape_exports, {
  noteShapeMigrations: () => noteShapeMigrations,
  noteShapeProps: () => noteShapeProps,
  noteShapeVersions: () => Versions
});
module.exports = __toCommonJS(TLNoteShape_exports);
var import_validate = require("@tldraw/validate");
var import_TLShape = require("../records/TLShape");
var import_TLColorStyle = require("../styles/TLColorStyle");
var import_TLFontStyle = require("../styles/TLFontStyle");
var import_TLHorizontalAlignStyle = require("../styles/TLHorizontalAlignStyle");
var import_TLSizeStyle = require("../styles/TLSizeStyle");
var import_TLVerticalAlignStyle = require("../styles/TLVerticalAlignStyle");
const noteShapeProps = {
  color: import_TLColorStyle.DefaultColorStyle,
  size: import_TLSizeStyle.DefaultSizeStyle,
  font: import_TLFontStyle.DefaultFontStyle,
  fontSizeAdjustment: import_validate.T.positiveNumber,
  align: import_TLHorizontalAlignStyle.DefaultHorizontalAlignStyle,
  verticalAlign: import_TLVerticalAlignStyle.DefaultVerticalAlignStyle,
  growY: import_validate.T.positiveNumber,
  url: import_validate.T.linkUrl,
  text: import_validate.T.string,
  scale: import_validate.T.nonZeroNumber
};
const Versions = (0, import_TLShape.createShapePropsMigrationIds)("note", {
  AddUrlProp: 1,
  RemoveJustify: 2,
  MigrateLegacyAlign: 3,
  AddVerticalAlign: 4,
  MakeUrlsValid: 5,
  AddFontSizeAdjustment: 6,
  AddScale: 7
});
const noteShapeMigrations = (0, import_TLShape.createShapePropsMigrationSequence)({
  sequence: [
    {
      id: Versions.AddUrlProp,
      up: (props) => {
        props.url = "";
      },
      down: "retired"
    },
    {
      id: Versions.RemoveJustify,
      up: (props) => {
        if (props.align === "justify") {
          props.align = "start";
        }
      },
      down: "retired"
    },
    {
      id: Versions.MigrateLegacyAlign,
      up: (props) => {
        switch (props.align) {
          case "start":
            props.align = "start-legacy";
            return;
          case "end":
            props.align = "end-legacy";
            return;
          default:
            props.align = "middle-legacy";
            return;
        }
      },
      down: "retired"
    },
    {
      id: Versions.AddVerticalAlign,
      up: (props) => {
        props.verticalAlign = "middle";
      },
      down: "retired"
    },
    {
      id: Versions.MakeUrlsValid,
      up: (props) => {
        if (!import_validate.T.linkUrl.isValid(props.url)) {
          props.url = "";
        }
      },
      down: (_props) => {
      }
    },
    {
      id: Versions.AddFontSizeAdjustment,
      up: (props) => {
        props.fontSizeAdjustment = 0;
      },
      down: (props) => {
        delete props.fontSizeAdjustment;
      }
    },
    {
      id: Versions.AddScale,
      up: (props) => {
        props.scale = 1;
      },
      down: (props) => {
        delete props.scale;
      }
    }
  ]
});
//# sourceMappingURL=TLNoteShape.js.map
